# Data Request Examples
- [Openstreetmap](#data-source-1-openstreetmap)
- [US Census Bureau boundary](#data-source-2-us-census-bureau-boundary)
- [US Census Bureau demography](#data-source-3-us-census-bureau-demography)
- [US COVID-19 data by New York Times](#data-source-4-us-covid-19-data-by-new-york-times)
- [OpenTopography](#data-source-5--opentopography-api-key-required)
- [OpenWeather data](#data-source-6-openweather-data)
- [ESRI World Imagery (for export):](#data-source-7-esri-world-imagery-for-export)


# Data source 1: Openstreetmap ([Video demonstration](https://youtu.be/4yVhVPFjCsw?si=qu8SWyoxvTbrMnLL))
Task1:Download all state boundaries of Nigeria. 

![Nigeria_States2.png](Docs%2FData%20request%20examples%2FNigeria_States2.png)

Task: Download all rivers in Yulin, Guangxi, China.

Task: Download the administrative boundary of Yulin, Guangxi, China.

![Yuling.png](Docs%2FData%20request%20examples%2FYuling.png)


# Data source 2: US Census Bureau boundary ([Video demonstration](https://youtu.be/WZhVv2st6Tw?si=I7XX-MljKbSuaS39))

Task: Download the boundaries of all the counties in the USA.

![USA_Counties.png](Docs%2FData%20request%20examples%2FUSA_Counties.png)


Task: Download all Census block group boundaries in Pennsylvania, USA.

![PA_blockgroup.png](Docs%2FData%20request%20examples%2FPA_blockgroup.png)

# Data source 3: US Census Bureau demography ([Video demonstration](https://youtu.be/ABhpBw5fkRo?si=VKM2cRR2-1O74UoO))


# Data source 4: US COVID-19 data by New York Times
Task: Download the COVID-19 case data of Richland County in South Carolina, USA. The time is from 2021-01 to 2021-09. [Video demonstration]()

![Richland_covid19.png](Docs%2FData%20request%20examples%2FRichland_covid19.png)

Task: Download the COVID-19 case data of all counties in Pennsylvania, USA. The time is from 2021-10 to 2022-02. [Video demonstration]()

![PA_covid19.png](Docs%2FData%20request%20examples%2FPA_covid19.png)

# Data source 5 : OpenTopography  (API Key required) ([Video demonstration](https://youtu.be/laruNGMzEfo?si=0BpCKViM2GREazYH))
Task: 
- Download the 30m resolution DEM of Chongqing, China from SRTMGL1.
- Download the administrative boundary of Chongqing, China.

![Chongqing_DEM.png](Docs%2FData%20request%20examples%2FChongqing_DEM.png)

Task:
- Download the 30m resolution DEM of Lhasa, China, from COP30.

![Lhasa_DEM.png](Docs%2FData%20request%20examples%2FLhasa_DEM.png)


# Data source 6: OpenWeather data


# Data source 7: ESRI World Imagery([Video demonstration](https://youtu.be/nhMR9i1NiVg?si=xOJVnfWZmS5DDBCU))

Task: Download the YellowStone National Park satellite image at level 10.

![YellowStone_park.png](Docs%2FData%20request%20examples%2FYellowStone_park.png)

Task: Download the Brasília satellite image at level 6.

![Brasilia.png](Docs%2FData%20request%20examples%2FBrasilia.png)

Task: Download the Nigeria satellite image at level 7

![Nigeria_Case.png](Docs%2FData%20request%20examples%2FNigeria_Case.png)


# Other examples to try: 
Download county boundaries for South Carolina. 

Download the fastfood restaurants as points in South Carolina. Please extract the restaurant names as a new field when saving the data. 

Download the gas stations as points in South Carolina, and extract the station names as a new field when saving the data. 

![SC_demo.png](Docs%2FData%20request%20examples%2FSC_demo.png)
